#include <iostream>
#include <vector>

using namespace std;

typedef long long ll;

struct Node {
  Node *l = nullptr, *r = nullptr;
  ll value, sum, height = 1, count = 1, totalCount;
};

ll balance(Node* node){
  return (node->l ? node->l->height : 0) - (node->r ? node->r->height : 0);
}

void update(Node* node){
  node->height = 1 + max(node->r ? node->r->height : 0, node->l ? node->l->height : 0);
  node->sum = (node->r ? node->r->sum : 0) + (node->l ? node->l->sum : 0) + node->count * node->value;
  node->totalCount = node->count + (node->r ? node->r->totalCount : 0) + (node->l ? node->l->totalCount : 0);
}

Node* left(Node* node){
  Node* root = node->r;

  node->r = root->l;
  update(node);

  root->l = node;
  update(root);

  return root;
}

Node* right(Node* node){
  Node* root = node->l;

  node->l = root->r;
  update(node);

  root->r = node;
  update(root);

  return root;
}

Node* insert(ll value, Node* node){
  if (node == nullptr){
    node = new Node;

    node->value = value;
    node->sum = value;
    node->totalCount = 1;

    return node;
  }

  if (value == node -> value){
    node->count++;
  }else if(value > node -> value){
    node->r = insert(value, node->r);
  }else{
    node->l = insert(value, node->l);
  }

  update(node);

  if (balance(node) < -1 && balance(node->r) <= 0){
    return left(node);
  }

  if (balance(node) < -1 && balance(node->r) > 0){
    node->r = right(node->r);
    return left(node);
  }

  if (balance(node) > 1 && balance(node->l) >= 0){
    return right(node);
  }

  if (balance(node) > 1 && balance(node->l) < 0){
    node->l = left(node->l);
    return right(node);
  }

  return node;
}

Node* remove(ll value, Node* node, bool override = false){
  if (value == node -> value){
    node->count--;

    if (node->count != 0 && !override)
      return node;

    if(node->l == nullptr || node->r == nullptr){
      Node* root = node->l ? node->l : node->r;
      delete node;

      if (root){
        node = root;
      }else{
        return nullptr;
      }
    }else{
      Node* current = node->r;

      while (current -> l) 
        current = current -> l;

      node->count = current->count;
      node->value = current->value;

      node->r = remove(current->value, node->r, true);
    }
  }else if(value > node -> value){
    node->r = remove(value, node->r);
  }else{
    node->l = remove(value, node->l);
  }
  
  update(node);

  if (balance(node) < -1 && balance(node->r) <= 0){
    return left(node);
  }

  if (balance(node) < -1 && balance(node->r) > 0){
    node->r = right(node->r);
    return left(node);
  }

  if (balance(node) > 1 && balance(node->l) >= 0){
    return right(node);
  }

  if (balance(node) > 1 && balance(node->l) < 0){
    node->l = left(node->l);
    return right(node);
  }

  return node;
}

ll prefixSum(ll n, Node* node){
  if (!node)
    return 0;

  n = min(n, node->totalCount);

  ll l = node->l ? node->l->totalCount : 0;

  if (n <= l){
    return prefixSum(n, node->l);
  }

  if (n > l + node->count){
    return (node->l ? node->l->sum : 0) + node->count * node->value + prefixSum(n - l - node->count, node->r);
  }

  return (node->l ? node->l->sum : 0) + node->value * (n - l);
}

int main(){
  ios_base::sync_with_stdio(false), cin.tie(0);

  ll n,q;cin>>n>>q;

  vector<ll> a(n);
  vector<ll> values(n + 1, 0);
  Node* root = nullptr;
  ll elements = 0;

  for (ll i = 0; i < n; ++i){
    cin>>a[i];
    values[a[i]] += a[i];
  }

  for (ll i = 1; i <= n; ++i){
    if (values[i]){
      ++elements;
      root = insert(values[i], root);
    }
  }

  for (ll i = 0; i < q; ++i){
    ll t;cin>>t;

    if (t == 1){
      ll k;cin>>k;
      ll amount = elements - n + k;
      cout<<(amount > 0 ? prefixSum(amount, root) : 0)<<'\n';
    }else{
      ll x,y;cin>>x>>y;
      --x;

      root = remove(values[a[x]], root);
      values[a[x]] -= a[x];

      if (values[a[x]]){
        root = insert(values[a[x]], root);
      }else{
        --elements;
      }

      a[x] = y;

      if (values[y]){
        root = remove(values[y], root);
      }else{
        ++elements;
      }

      values[y] += y;
      root = insert(values[y], root);
    }
  }

  return 0;
}